package cn.smarthse.services.hfi.api.pojo.vo;

import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.services.hfi.api.entity.CheckPlan;

/**
 * @author 邓力宾
 * @date 2020/10/14 16:23
 * @desc
 */
public class ComCheckPlanListVo extends CheckPlan {

    private String updateDateStr;
    private String checkDateStr;
    private String checkTypeStr;
    private String reportDateStr;
    private String relevanceDateStr;



    public String getUpdateDateStr(){
        if(this.getUpdateDate() != null){
            return DateUtil.formatDate(this.getUpdateDate(), "yyyy-MM-dd");
        }
        return "";
    }
    public String getRelevanceDateStr(){
        if(this.getRelevanceDate() != null){
            return DateUtil.formatDate(this.getRelevanceDate(), "yyyy-MM-dd");
        }
        return "";
    }

    public String getCheckDateStr(){
        if(this.getCheckDateBegin() != null && this.getCheckDateEnd() != null){
            return DateUtil.formatDate(this.getCheckDateBegin(), "yyyy-MM-dd") + "至" +
                    DateUtil.formatDate(this.getCheckDateEnd(), "yyyy-MM-dd");
        }
        return  "";
    }
    public String getReportDateStr(){
        if(this.getReportDate() != null){
            return DateUtil.formatDate(this.getReportDate(), "yyyy-MM-dd");
        }
        return  "";
    }

    public String getCheckTypeStr(){
        if(this.getCheckType() == null){
            return  "";
        }
        if(this.getCheckType().intValue() == 1) {
            return "日常监测";
        }
        if(this.getCheckType().intValue() == 2) {
            return "定期检测";
        }
        if(this.getCheckType().intValue() == 3) {
            return "现状评价涉及的检测";
        }
        if(this.getCheckType().intValue() == 4) {
            return "控评涉及的检测";
        }
        if(this.getCheckType().intValue() == 5) {
            return "整改后检测";
        }
        return "";
    }

}
