package cn.smarthse.services.hfi.api.pojo.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author 邓力宾
 * @date 2020/10/20 09:46
 * @desc 日常监测 档案 vo 采样点以及检测结果 一个对象表示一个结果集
 */
@Data
public class CheckRecordFileVo implements Serializable {

    private Long cid;

    private String comName;

    private String checkPointName; //采样点

    private String factorName; //危害因素名称

    private String showJudgeResult; // 判定结果 显示用


    private String checkCycle;// 监测周期（天）

    private Long checkId; //检测id

    private LocalDateTime checkDate; //检测日期


//    检测项目id
//        (1, '化学因素');
//        (2, '粉尘');
//        (3, '噪声');
//        (4, '高温');
//        (5, '紫外辐射');
//        (6, '工频电场');
//        (7, '微波辐射');
//        (8, '高频电磁场');
//        (9, '超高频辐射');
//        (10, '电离辐射');
//        (11, '手传振动');
//        (12, '激光辐射');
//        (13, '生物因素');
//        (14, '照度');
//        (15, '微小气候');
//        (16, '新风量');
//        (17, '控制风速');
    private Long itemId; //检测项目id

    private Long resultNo; //结果集编号

    private String factorId; // 危害因素id

    private String judgeResult; // 结果判定 1:不判断 2:符合 3:不符合

    private List<CheckRecordFileCheckResultVo> resultList; //检测结果 集合

    @ApiModelProperty(value = "车间名称")
    private String workshop;

    @ApiModelProperty(value = "岗位/工种")
    private String workName;

    @ApiModelProperty(value = "定员")
    private Integer workNum;
}

