package cn.smarthse.services.hfi.api.pojo.vo;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author 邓力宾
 * @date 2020/10/20 09:53
 * @desc 日常监测 档案 检测结果 vo
 */
@Data
public class CheckRecordFileCheckResultVo implements Serializable {

    private Long cid;

    private String comName;

    private String showUnit;//单位 显示用（包括指标和单位）

    private String showCheckValue;//检测值 显示用（值或是范围）

    private String showTouchLimitValue; //职业接触限值

    private String showTouchLimitUnit;//职业接触限值单位



    private Long checkId; //检测id

    private LocalDateTime checkDateBegin;//检测日期

    private Long itemId; //检测项目id

    private String itemName;//检测项目名称 如 化学因素，生物因素，粉尘，噪声...

    private Integer itemType;//  1:危害因素类型 2：危害因素 3：既不是危害因素类型也不是危害因素表中的危害因素

    private Long factorId; // itemType为2时有效,危害因素id occupational_risk_factors表id字段

    private Long resultNo;//检测结果集编号


    private Integer targetId; //指标id

    private String targetName; //指标名称

    //@ApiModelProperty(value = "指标单位")
    private String unit;

    private String  checkUnit;//添加检测结果时，手动指定的单位


    // "值类型1：准确值 2：范围"
    private Integer checkValueType;

    //@ApiModelProperty(value = "指标的值（准确值）(结果是准确的值时，该字段有效，结果的类型查看当前指标对应的值类型)")
    private String checkValue;


   // @ApiModelProperty(value = "结果是范围时，范围类型：1:-，2:< ，3:<=")
    private Integer checkValueRangeType;

   // @ApiModelProperty(value = "指标的值（范围下限）")
    private String checkValueMin;

    //@ApiModelProperty(value = "指标的值（范围上限）")
    private String checkValueMax;




}
