package cn.smarthse.services.hfi.api.pojo.vo;

import cn.smarthse.util.common.date.DateUtils;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author 邓力宾
 * @date 2020/10/23 10:29
 * @desc 采样点
 */
@Data
public class CheckPointSelectVo implements Serializable {
    private Long checkPointResultNo; //采样点结果集id

    private String checkPointName; //采样点名称

    private String factorName; //检测的危害因素名称

    private String judgeResult;//当前采样点判定结果


    private Long checkId; // 检测id

    private String checkProjectName;//检测项目名称

    private LocalDateTime checkDateBegin;//检测时间

    private String checkDateBeginStr;

    public String getCheckDateBeginStr(){
        if(checkDateBegin == null){
            return "";
        }
        return DateUtils.formatDate(this.checkDateBegin, "yyyy-MM-dd");
    }



}
