package cn.smarthse.services.hfi.api.pojo.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

/**
 * @author 邓力宾
 * @date 2021/1/8 9:38
 * @desc
 */
@Data
public class CheckPointCountVo implements Serializable {
    //以下字段用于分组 分组类型：行政区划、经济类型、行业类别、企业规模、风险分类
    private String groupName; //分组名称 如果按行政区划分组 如：杭州市，湖州市
    private String groupKey;//分组key 如果按行政区划分组 可以设置成区域id
    private String tag;//标记

    private Integer totalComCount = 0;//企业总数
    private Integer checkComCount = 0;//已检测企业数
    private List<Long> checkComIds = new LinkedList<>();//已检测企业id
    private String checkRate;//检测率
    private Integer failComCount = 0;//超标企业数
    private Integer checkPointCount = 0;//检测点总数
    private Integer failPointCount = 0;//超标点总数
    private String overRate;//超标率



    //检测率
    public String getCheckRate() {

            if(!totalComCount.equals(0)){
                return (checkComCount) * 100 / totalComCount +"%"; //超标率
            }
            return "0%";
    }
    //超标率
    public String getOverRate() {
        if(!checkPointCount.equals(0)){
            return (failPointCount) * 100 / checkPointCount +"%"; //超标率
        }
        return "0%";
    }
}
