package cn.smarthse.services.hfi.api.pojo.vo;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author Denglibin
 * @date 2021/12/17 9:13
 * @desc 检测超标点
 */
@Data
public class CheckOverPointVo implements Serializable {
    private Long cid; //企业id

    private  Long checkId; //检测id

    private String checkWorkName; //检测工作名称

    private Long resultId; //超标点结果id

    private Long resultNo; //超标点结果集编号

    private Long targetId; //指标id

    private Long itemId; //检测项目id //1, '化学因素' 2, '粉尘' 3, '噪声'

    private String  checkPointName; //检测点位名称

    private String checkProject; //检测项目（危害因素名称）

    private Long factorId; //危害因素id

    private LocalDateTime findTime; //发现时间

    private LocalDateTime checkDateBegin;//检测时间

    /**
     * 隐患名称
     * @return
     */
    public String getReformName(){
        if (checkDateBegin !=null){
            return checkDateBegin.getYear()+"-"+checkPointName+"-"+checkProject+"-浓强度超标";
        }else {
            return checkPointName+"-"+checkProject+"-浓强度超标";
        }
    }
}
