package cn.smarthse.services.hfi.api.pojo.vo;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author 邓力宾
 * @date 2020/10/20 12:01
 * @desc 检测档案
 */
@Data
public class CheckFileVo implements Serializable {
    private Long checkId; //检测id

    private String checkWorkName; //检测工作名称

    private String managerName; //负责人

    List<CheckRecordFileVo> pointResults;// 采样点检测结果

    private Integer totalLine = 0;

    private Long cid;
    private String comName;
    private LocalDateTime checkDate; //检测日期

    public Integer getTotalLine() {
        if(pointResults==null||pointResults.isEmpty()) return  totalLine;
        pointResults.forEach(p->{
            List<CheckRecordFileCheckResultVo> resultList = p.getResultList();
            if(resultList!=null&&!resultList.isEmpty()){
                totalLine += resultList.size();
            }
        });
        return totalLine;
    }
}
