package cn.smarthse.services.hfi.api.model.riskev;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author 吴嘉诚
 * @Comments:
 * @since 2022/3/17 10:46
 */
@Data
@Accessors(chain = true)
public class EvQueryParam implements Serializable {

    private Integer page;   //页码

    private Integer rows;   //每页大小

    private Long cid; //企业id
    private List<Long> cidList;

    private Long orgId;//机构id

    private String keyWord;     //项目名称/委托单位

    private Long areaId;    //区域ID

    private Byte level;     //区域级别

    private LocalDateTime startTime;    //检测开始时间

    private LocalDateTime endTime;      //检测结束时间

    //1:待提交 2：待审核 3：被退回待提交 4：审核完成 5:最新的审核通过之后的中间数据 10：错误数据
    private Integer reportStatus;
    private List<Integer> reportStatusList;

    //"检测类型: 1日常监测 2定期检测、3现状评价、4控制效果评价"
    private List<Long> checkTypeList;

    private Boolean isIgnore; //是否忽略
    //cn.smarthse.services.hfi.api.entity.riskev.RiskExposeEvaluate.flag
    private Integer showFlag;//退回时，旧表flag是0，新表flag是1，退回上报之后产生的历史数据是2

    //redundant_source_tables_ids不为空的暴露风险id
    private List<Long> sourceIdList;

    Boolean isOderByCheckDate = false;

    Boolean isQueryRiskData = false;
}
