package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《紫外辐射》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:48
 */
@Data
public class UltravioletLightListModel extends BaseResultListMode {
    //紫外光谱分类
    private String ultraType;
    //接触时间
    private String contactTime;
    //辐照度(μW/cm<sup>2</sup>)
    private String uw;
    //照射量(mJ/cm<sup>2</sup>
    private String mj;

    //辐照度(μW/cm<sup>2</sup>)(罩内眼部)
    private String uwEye;
    //照射量(mJ/cm<sup>2</sup>)(罩内眼部)
    private String mjEye;
    //结果判定(罩内眼部)
    private String judgedEye;

    //辐照度(μW/cm<sup>2</sup>)(罩内面部)
    private String uwFace;
    //照射量(mJ/cm<sup>2</sup>)(罩内面部)
    private String mjFace;
    //结果判定(罩内面部)
    private String judgedFace;

    //辐照度(μW/cm<sup>2</sup>)(无)
    private String uwNone;
    //照射量(mJ/cm<sup>2</sup>)(无)
    private String mjNone;
    //结果判定(无)
    private String judgedNone;

    public static UltravioletLightListModel covert(List<CheckResult> results){
        UltravioletLightListModel model = new UltravioletLightListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==38){
                model.setCheckObject(checkValue);
            }else if(targetId==39){
                String type = "";
                //1.中波紫外线;2.短波紫外线;3.电焊弧光
                if("1".equals(checkValue)){
                    type = "中波紫外线";
                }else if("2".equals(checkValue)){
                    type = "短波紫外线";
                }else if("3".equals(checkValue)){
                    type = "电焊弧光";
                }
                model.setUltraType(type);
            }else if(targetId==40){
                model.setContactTime(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==41){
                model.setUw(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==42){
                model.setMj(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==43){
                model.setJudged(JudgeStateEnum.getName(checkValue));
            }else if(targetId==44){
                model.setUwEye(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==45){
                model.setMjEye(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==46){
                model.setJudgedEye(JudgeStateEnum.getName(checkValue));
            }else if(targetId==47){
                model.setUwFace(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==48){
                model.setMjFace(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==49){
                model.setJudgedFace(JudgeStateEnum.getName(checkValue));
            }else if(targetId==50){
                model.setUwNone(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==51){
                model.setMjNone(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==52){
                model.setJudgedNone(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(140).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(141).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(142).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }
    public static List<UltravioletLightListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap){
        List<UltravioletLightListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            UltravioletLightListModel model = covert(rowList);
            models.add(model);
        }
        return models;
    }
}
