package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《超高频辐射》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:48
 */
@Data
public class UltrahighFrequencyRadiationListModel extends BaseResultListMode {
    //类型
    private String type;
    //接触时间
    private String hour;
    //功率密度
    private String mw;
    //电场强度
    private String powerLevel;

    public static UltrahighFrequencyRadiationListModel covert(List<CheckResult> results){
        UltrahighFrequencyRadiationListModel model = new UltrahighFrequencyRadiationListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==70){
                model.setCheckObject(checkValue);
            }else if(targetId==71){
                //1:连续波;2:脉冲波
                model.setType(checkValue);
            }else if(targetId==72){
                model.setHour(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==73){
                model.setMw(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==74){
                model.setPowerLevel(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==75){
                model.setJudged(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(156).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(157).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(158).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }
    public static List<UltrahighFrequencyRadiationListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap){
        List<UltrahighFrequencyRadiationListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            UltrahighFrequencyRadiationListModel model = covert(rowList);
            models.add(model);
        }
        return models;
    }
}
