package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.services.hfi.api.entity.CheckResult;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ResultUtils {
    public static Map<Long, List<CheckResult>> splitByRowNum(List<CheckResult> results){
        Map<Long,List<CheckResult>> resultRowMap = new TreeMap<>();
        if(CollectionUtils.isEmpty(results)) return resultRowMap;
        results.forEach(l->{
            Long rowNum = l.getResultNo();
            List<CheckResult> rowList = resultRowMap.get(rowNum)==null?new ArrayList<>():resultRowMap.get(rowNum);
            rowList.add(l);
            resultRowMap.put(rowNum,rowList);
        });
        return resultRowMap;
    }
    public static boolean isNotEmpty(String str){
        if (str == null)
            return false;
        str = str.trim();
        return !str.equals("");
    }
    public static String getBiologicalUnit(String harmId,String unit){
        if("596".equals(harmId)){
            return "孢子数/m³";
        }else if("597".equals(harmId)){
            return "ng/m³";
        }else if(unit == null){
            return "";
        }else return unit;
    }
    public static String getRange(Integer rangeType, String min,String max){
        String s = "";
        if(rangeType == null){

        }else if(rangeType.equals(2)){
            s += "<";
       }else if(rangeType.equals(3)){
           s += "≤";
       }
       if((min !=null && min.length()>0) && (max != null && max.length() > 0)){
           if(min.equals(max)){
               s += " "+ min;
           }else {
               s += " "+ min +"~"+max;
           }

           return s;
       }
       if((min == null || min.isEmpty()) && (max == null || max.isEmpty())){
           return "";
       }
       if(min == null || min.isEmpty()){
           s +=  " " + max;
           return s;
       }
       return s +" " + min;
    }
    public static String[] getRadiationArr(String radiations){
        String[] arr1 = new String[4];
        if(!isNotEmpty(radiations)) return arr1;
        String[] arr = radiations.split(",");
        if(arr.length<4){
            for(int i=0;i<arr.length;i++){
                arr1[i] = arr[i];
            }
            for(int i=arr.length;i<4;i++){
                arr1[i] = "";
            }
        }else {
            arr1 = arr;
        }
        return arr1;
    }
    public static String getRadiation(Integer rangeType,String radiations){
        String[] arr1 = getRadiationArr(radiations);
        String exposure="";

        if(rangeType == null){

        }else if(rangeType.equals(2)){
            exposure += "<";
        }else if(rangeType.equals(3)){
            exposure += "≤";
        }

        if(isNotEmpty(arr1[0])){
            exposure+=arr1[0];
        }
        if(isNotEmpty(arr1[1])){
            exposure+="×10" + getSuperscript(arr1[1]);
        }
        if(isNotEmpty(exposure)&&(isNotEmpty(arr1[2])||isNotEmpty(arr1[3]))){
            exposure+="~";
        }
        if(isNotEmpty(arr1[2])){
            exposure+=arr1[2];
        }
        if(isNotEmpty(arr1[3])){
            exposure+="×10" + getSuperscript(arr1[3]);
        }
        return exposure;
    }
    public static String getType1(String type){
        //选项：1.全身辐射,2.肢体局部辐射
        if("1".equals(type)){
            return "全身辐射";
        }else if("2".equals(type)){
            return "局部辐射";
        }
        return "";
    }
    public static String getType2(String type){
        // 1.连续微波, 2.脉冲微波。 结果值用英文逗号分开
        if("1".equals(type)){
            return "连续微波";
        }else if("2".equals(type)){
            return "脉冲微波";
        }
        return "";
    }
    public static String getNoiseType(String type){
        //1:个体 2：场所（稳态噪声）3：场所（非稳态噪声）4：场所（脉冲噪声）
        if("1".equals(type)){
            return "个体";
        }else if("2".equals(type)){
            return "稳态噪声";
        }else if("3".equals(type)){
            return "非稳态噪声";
        }else if("4".equals(type)){
            return "脉冲噪声";
        }else return "";
    }

    /**
     * 根据数字返回对应的上标
     * @param numChar
     * @return
     */
    public static String getSuperscript(String numChar){
        try{
            StringBuilder minus = new StringBuilder();

            String superscripts = "º¹²³⁴⁵⁶⁷⁸⁹"; //⁻˙
            for(int a = 0; a < numChar.length(); a++){
                char c = numChar.charAt(a);
                if(c == '.'){ ////小数点
                    minus.append("˙"); //小数点
                }else if(c == '-'){ //负号
                    minus.append("⁻");
                }else {
                    minus.append(superscripts.charAt(Integer.parseInt( c+ "")));
                }
            }
            return minus.toString();

        }catch (Exception e){
            //e.printStackTrace();
            return "";
        }
    }
}
