package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《工频电场》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:48
 */
@Data
public class PowerFrequencyListModel extends BaseResultListMode {
    //接触时间(h)
    private String contactTime;
    //电场强度(kV/m)
    private String powerLevel;

    public static PowerFrequencyListModel covert(List<CheckResult> results){
        PowerFrequencyListModel model = new PowerFrequencyListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==53){
                model.setCheckObject(checkValue);
            }else if(targetId==54){
                model.setContactTime(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==55){
                model.setPowerLevel(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==56){
                model.setJudged(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(144).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(145).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(146).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }
    public static List<PowerFrequencyListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap){
        List<PowerFrequencyListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            PowerFrequencyListModel model = covert(rowList);
            models.add(model);
        }
        return models;
    }
}
