package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:57
 */
@Data
public class NoiseListModel extends BaseResultListMode {
    //噪声类型
    private String noiseType;
    //检测数值[dB(A)]
    private String checkedNum;
    //最低值[dB(A)]
    private String minNum;
    //最高值[dB(A)]
    private String maxNum;
    //8/40h等效声级[dB(A)]
    private String level;
    //工作日接触脉冲次数(次)
    private String times;
    //声压级峰值[dB(A)]
    private String peak;

    public static NoiseListModel covert(List<CheckResult> results){
        NoiseListModel model = new NoiseListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==24){
                model.setCheckObject(checkValue);
            }else if(targetId==25){
                model.setNoiseType(ResultUtils.getNoiseType(checkValue));
            }else if(targetId==26){
                model.setCheckedNum(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==27){
                model.setMinNum(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==28){
                model.setMaxNum(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==29){
                model.setLevel(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==30){
                model.setTimes(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==31){
                model.setPeak(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==32){
                model.setJudged(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(132).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(133).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(134).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }
    public static List<NoiseListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap){
        List<NoiseListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            NoiseListModel model = covert(rowList);
            models.add(model);
        }
        return models;
    }
}
