package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《微波辐射》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:48
 */
@Data
public class MicrowaveRadiationListModel extends BaseResultListMode {
    //
    private String type1;
    //
    private String type2;
    //受辐射时间(h)
    private String hour;
    //日剂量(μW·h/cm<sup>2</sup>)
    private String daliy;
    //平均功率密度(μW/cm<sup>2</sup>)
    private String avg;
    //短时间接触功率密度(mW/cm<sup>2</sup>)
    private String mw;

    public static MicrowaveRadiationListModel covert(List<CheckResult> results){
        MicrowaveRadiationListModel model = new MicrowaveRadiationListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==57){
                model.setCheckObject(checkValue);
            }else if(targetId==58){
                String[] types = checkValue.split(",");
                model.setType1(ResultUtils.getType1(types[0]));
                model.setType2(ResultUtils.getType2(types[1]));
            }else if(targetId==59){
                model.setHour(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==60){
                model.setDaliy(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==61){
                model.setAvg(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==62){
                model.setMw(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==63){
                model.setJudged(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(148).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(149).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(150).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }
    public static List<MicrowaveRadiationListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap){
        List<MicrowaveRadiationListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            MicrowaveRadiationListModel model = covert(rowList);
            models.add(model);
        }
        return models;
    }
}
