package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《微小气候》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:48
 */
@Data
public class MicroclimateListModel extends BaseResultListMode {
    //
    private String tempResult;
    //
    private String tempJudged;
    //
    private String speedResult;
    //
    private String speedJudged;
    //
    private String humidityResult;
    //
    private String humidityJudged;

    public static MicroclimateListModel covert(List<CheckResult> results){
        MicroclimateListModel model = new MicroclimateListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==108){
                model.setCheckObject(checkValue);
            }else if(targetId==109){
                model.setTempResult(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==110){
                model.setTempJudged(JudgeStateEnum.getName(checkValue));
            }else if(targetId==111){
                model.setSpeedResult(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==112){
                model.setSpeedJudged(JudgeStateEnum.getName(checkValue));
            }else if(targetId==113){
                model.setHumidityResult(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==114){
                model.setHumidityJudged(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(180).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(181).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(182).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }
    public static List<MicroclimateListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap){
        List<MicroclimateListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            MicroclimateListModel model = covert(rowList);
            models.add(model);
        }
        return models;
    }
}
