package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《激光辐射》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:48
 */
@Data
public class LaserRadiationListModel extends BaseResultListMode {
    //接触部位
    private String position;
    //接触时间
    private String hour;
    //光谱范围
    private String range;
    //波长(nm)
    private String len;
    //照射时间(s)
    private String time;
    //照射量(J/cm<sup>2</sup>)
    private String j;
    //辐照度(W/cm<sup>2</sup>)
    private String w;

    public static LaserRadiationListModel covert(List<CheckResult> results){
        LaserRadiationListModel model = new LaserRadiationListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==88){
                model.setCheckObject(checkValue);
            }else if(targetId==89){
               model.setPosition(checkValue);
            }else if(targetId==90){
                model.setHour(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==91){
                model.setRange(checkValue);
            }else if(targetId==92){
                model.setLen(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==93){
                model.setTime(ResultUtils.getRadiation(l.getCheckValueRangeType(),checkValue));
            }else if(targetId==94){
                model.setJ(ResultUtils.getRadiation(l.getCheckValueRangeType(),checkValue));
            }else if(targetId==95){
                model.setW(ResultUtils.getRadiation(l.getCheckValueRangeType(),checkValue));
            }else if(targetId==96){
                model.setJudged(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(168).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(169).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(170).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }
    public static List<LaserRadiationListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap){
        List<LaserRadiationListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            LaserRadiationListModel model = covert(rowList);
            models.add(model);
        }
        return models;
    }
}
