package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《电离辐射-射线装置》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:48
 */
@Data
public class IonizingRadiationListModel extends BaseResultListMode {
    //检测点位置
    private String position;
    //范围类型：1:-，2:< ，3:<=
    private Integer checkResultType;
    //检测结果(μSv/h)
    private String checkResult;
    //射线id或含源装置id
    private String deviceOrSourceId;

    public static IonizingRadiationListModel covert(List<CheckResult> results){
        IonizingRadiationListModel model = new IonizingRadiationListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==77||targetId==81){
                model.setPosition(checkValue);
            }else if(targetId==76||targetId==80){
                model.setDeviceOrSourceId(checkValue);
            }else if(targetId==78||targetId==82){
                model.setCheckResultType(l.getCheckValueRangeType());
                model.setCheckResult(l.getCheckValueMin());
            }else if(targetId==79||targetId==83){
                model.setJudged(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(160).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(161).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(162).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }
    public static List<IonizingRadiationListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap){
        List<IonizingRadiationListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            IonizingRadiationListModel model = covert(rowList);
            models.add(model);
        }
        return models;
    }
}
