package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《照度》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:48
 */
@Data
public class IlluminancyListModel extends BaseResultListMode {

    private String checkResult;

    public static IlluminancyListModel covert(List<CheckResult> results){
        IlluminancyListModel model = new IlluminancyListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==105){
                model.setCheckObject(checkValue);
            }else if(targetId==106){
                model.setCheckResult(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==107){
                model.setJudged(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(176).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(177).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(178).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }
    public static List<IlluminancyListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap){
        List<IlluminancyListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            IlluminancyListModel model = covert(rowList);
            models.add(model);
        }
        return models;
    }
}
