package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:48
 */
@Data
public class HighTemperatureListModel extends BaseResultListMode {
    //接触时间率
    private String contactRate;
    //体力劳动强度
    private String strength;
    private String checkResult;

    public static HighTemperatureListModel covert(List<CheckResult> results){
        HighTemperatureListModel model = new HighTemperatureListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==33){
                model.setCheckObject(checkValue);
            }else if(targetId==34){
                model.setContactRate(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==35){
                model.setStrength(getValue35(checkValue));
            }else if(targetId==36){
                model.setCheckResult(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==37){
                model.setJudged(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(136).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(137).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(138).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }
    public static List<HighTemperatureListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap){
        List<HighTemperatureListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            HighTemperatureListModel model = covert(rowList);
            models.add(model);
        }
        return models;
    }

    /**
     * 体力劳动强度
     * @param checkValue 1:Ⅰ,2:Ⅱ,3:Ⅲ,4:Ⅳ
     * @return
     */
    private static String getValue35(String checkValue) {
        switch (checkValue){
            case "1":
                return "Ⅰ";
            case "2":
                return "Ⅱ";
            case "3":
                return "Ⅲ";
            case "4":
                return "Ⅳ";
            default:
                return "";
        }
    }
}
