package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《高频电磁场》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:48
 */
@Data
public class HighFrequencyListModel extends BaseResultListMode {
    //频率
    private String rate;
    //接触时间
    private String hour;
    //电场强度
    private String powerLevel;
    //磁场强度
    private String freLevel;

    public static HighFrequencyListModel covert(List<CheckResult> results){
        HighFrequencyListModel model = new HighFrequencyListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==64){
                model.setCheckObject(checkValue);
            }else if(targetId==65){
                model.setRate(ResultUtils.getRange(l.getCheckValueRangeType(),  l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==66){
                model.setHour(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==67){
                model.setPowerLevel(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==68){
                model.setFreLevel(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==69){
                model.setJudged(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(152).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(153).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(154).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }
    public static List<HighFrequencyListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap){
        List<HighFrequencyListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            HighFrequencyListModel model = covert(rowList);
            models.add(model);
        }
        return models;
    }
}
