package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《手传振动》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:48
 */
@Data
public class HandTranSmittedListModel extends BaseResultListMode {
    //接触时间h
    private String hour;
    //h等能量频率计权振动加速度
    private String speed;

    public static HandTranSmittedListModel covert(List<CheckResult> results){
        HandTranSmittedListModel model = new HandTranSmittedListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==84){
                model.setCheckObject(checkValue);
            }else if(targetId==85){
                model.setHour(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==86){
                model.setSpeed(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==87){
                model.setJudged(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(164).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(165).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(166).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }
    public static List<HandTranSmittedListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap){
        List<HandTranSmittedListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            HandTranSmittedListModel model = covert(rowList);
            models.add(model);
        }
        return models;
    }
}
