package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《新风量》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:48
 */
@Data
public class FreshAirRateListModel extends BaseResultListMode {
    //是否洁净厂房
    private String isDirty;
    //
    private String checkResult;
    //人数
    private String num;
    //人均新风量
    private String avg;

    public static FreshAirRateListModel covert(List<CheckResult> results){
        FreshAirRateListModel model = new FreshAirRateListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==115){
                model.setCheckObject(checkValue);
            }else if(targetId==116){
                model.setCheckResult(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(), l.getCheckValueMax()));
            }else if(targetId==117){
                if("1".equals(checkValue)){
                    model.setIsDirty("是");
                }else if("2".equals(checkValue)){
                    model.setIsDirty("否");
                }
            }else if(targetId==118){
                model.setNum(checkValue);
            }else if(targetId==119){
                model.setAvg(checkValue);
            }else if(targetId==120){
                model.setJudged(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(187).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(184).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(185).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }
        });
        return model;
    }
    public static List<FreshAirRateListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap){
        List<FreshAirRateListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            FreshAirRateListModel model = covert(rowList);
            models.add(model);
        }
        return models;
    }
}
