package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:49
 */
@Data
public class DustListModel extends BaseResultListMode {
    //CTWA总尘(mg/m³)
    private String totalTwa;
    //总尘浓度范围(mg/m³)
    private String totalRange;
    //总尘峰接触浓度(mg/m³)
    private String totalPeak;
    //超限倍数(总尘)
    private String totalOverTimes;
    //折减因子总尘（v315）
    private String reductionFactorTotal;
    //结果判定(总尘)
    private String totalResult;

    //CTWA呼尘(mg/m³)
    private String respTwa;
    //呼尘浓度范围(mg/m³)
    private String respRange;
    //呼尘峰接触浓度
    private String respPeak;
    //呼尘超限倍数
    private String respOverTimes;

    //折减因子呼尘（v315）
    private String reductionFactorResp;

    //呼尘结果判定
    private String respResult;

    public static DustListModel covert(List<CheckResult> results, Map<String, String> allHarmMap){
        DustListModel model = new DustListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==11){
                model.setCheckObject(checkValue);
            }else if(targetId==12){
                String s = allHarmMap.get(checkValue);
                if(s != null){
                    model.setCheckProject(s);
                    model.setHarmId(checkValue);
                }else {
                    model.setCheckProject(checkValue);
                    model.setHarmId("");
                }

            }else if(targetId==13){
                model.setTotalTwa(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==14){
                model.setTotalRange(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==15){
                model.setTotalPeak(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==16){
                model.setTotalOverTimes(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==17){
                model.setTotalResult(JudgeStateEnum.getName(checkValue));
            }else if(targetId==18){
                model.setRespTwa(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==19){
                model.setRespRange(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==20){
                model.setRespPeak(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==21){
                model.setRespOverTimes(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax()));
            }else if(targetId==22){
                model.setRespResult(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(128).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(129).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(130).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }else if(Integer.valueOf(193).equals(targetId)){
                model.setReductionFactorTotal(checkValue);
            }else if(Integer.valueOf(195).equals(targetId)){
                model.setReductionFactorResp(checkValue);
            }
        });
        return model;
    }
    public static List<DustListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap,Map<String, String> allHarmMap){
        List<DustListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            DustListModel model = covert(rowList,allHarmMap);
            models.add(model);
        }
        return models;
    }
}
