package cn.smarthse.services.hfi.api.model.result;

import cn.smarthse.common.util.number.NumberUtil;
import cn.smarthse.services.hfi.api.entity.CheckResult;
import cn.smarthse.services.hfi.api.enums.JudgeStateEnum;
import cn.smarthse.services.hfi.api.model.BaseResultListMode;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 《》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @since 2020/8/25 13:48
 */
@Data
public class BiologicalListModel extends BaseResultListMode {
    private String me;
    private String mac;
    private String twa;
    private String ste;
    private String stel;
    //折减因子（v315）
    private String reductionFactor;


    public static BiologicalListModel covert(List<CheckResult> results,Map<String, String> allHarmMap){
        BiologicalListModel model = new BiologicalListModel();
        results.forEach(l->{
            model.setResultNo(l.getResultNo());
            model.setCheckId(l.getCheckId());
            Integer targetId = l.getTargetId();
            String checkValue = l.getCheckValue();
            if(targetId==97){
                model.setCheckObject(checkValue);
            }else if(targetId==98){
                String s = allHarmMap.get(checkValue);
                if(s != null){
                    model.setCheckProject(s);
                    model.setHarmId(checkValue);
                }else {
                    model.setCheckProject(checkValue);
                    model.setHarmId("");
                }
            }else if(targetId==99){
                model.setMac(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax())+ResultUtils.getBiologicalUnit(model.getHarmId(),l.getUnit()));
            }else if(targetId==100){
                model.setMe(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax())+ResultUtils.getBiologicalUnit(model.getHarmId(),l.getUnit()));
            }else if(targetId==101){
                model.setTwa(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax())+ResultUtils.getBiologicalUnit(model.getHarmId(),l.getUnit()));
            }else if(targetId==102){
                model.setStel(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax())+ResultUtils.getBiologicalUnit(model.getHarmId(),l.getUnit()));
            }else if(targetId==103){
                model.setSte(ResultUtils.getRange(l.getCheckValueRangeType(), l.getCheckValueMin(),l.getCheckValueMax())+ResultUtils.getBiologicalUnit(model.getHarmId(),l.getUnit()));
            }else if(targetId==104){
                model.setJudged(JudgeStateEnum.getName(checkValue));
            }else if(Integer.valueOf(172).equals(targetId)){
                model.setWorkshopName(checkValue);
            }else if(Integer.valueOf(173).equals(targetId)){
                model.setWorkName(checkValue);
            }else if(Integer.valueOf(174).equals(targetId)&& NumberUtil.isDigits(checkValue)){
                model.setHarmStaffCount(Integer.valueOf(checkValue));
            }else if(Integer.valueOf(194).equals(targetId)){
                model.setReductionFactor(checkValue);
            }
        });
        return model;
    }
    public static List<BiologicalListModel> covertMap(Map<Long,List<CheckResult>> resultRowMap,Map<String, String> allHarmMap){
        List<BiologicalListModel> models = new ArrayList<>();
        if(CollectionUtils.isEmpty(resultRowMap)) return models;
        for(Map.Entry<Long, List<CheckResult>> entry : resultRowMap.entrySet()){
            List<CheckResult> rowList = entry.getValue();
            BiologicalListModel model = covert(rowList,allHarmMap);
            models.add(model);
        }
        return models;
    }
}
