package cn.smarthse.services.hfi.api.model.list;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
@Accessors(chain = true)
public class CheckPlanListParam implements Serializable {
    private Long cid;
    private List<Long> cids;
    private Long areaId;
    private Byte areaLevel;
    //检测机构、项目名称、委托单位
    private String keyword;
    private Date giveReportTimeBegin;
    private Date giveReportTimeEnd;
    private Date reportTimeBegin;
    private Date reportTimeEnd;
    private Boolean hasOverPoint;
    private Boolean hasEemptyResult;
    private Boolean hasFeedback;
    private List<Integer> status;
    private Date checkDateBegin;
    private Date checkDateEnd;

    private Byte ownLevel; //只查委托单位为直属当前辖区（1：省 2：市）的企业数据
    //检测类型
    private Byte checkType;
    private List<Byte> checkTypeList;
    private Long thirdOrgId;
    // 上报状态(1:未上报 2：已上报 3：被退回 4:已忽略
    private List<Integer> reportStatusList;
    private String reportStatusSortType; // 上报状态（report_status） 排序方式 asc, desc

    private String reportDateSortType; // 上报日期（report_date） 排序方式 asc, desc

    private String giveReportTimeSortType; // 报告出具日期 排序方式 asc, desc

    private String companyNameSortType; // 委托单位 排序方式 asc, desc

    private String checkBeginTimeSortType;// 检测时间排序 方式 asc, desc

    private String checkPointsSortType;// 检测点排序 方式 asc, desc

    private String passPointsSortType;// 合格点排序 方式 asc, desc

    private String overPointsSortType;// 超标点排序 方式 asc, desc

    private String overRateSortType;// 超标率排序 方式 asc, desc

    private List<Integer> checkTypes;//检测类型 多个

    private String workNo;//工作编号

    private Integer checkResultType;//检测结果 1：所有，2：部分符合（超标率不为0） 3：全部符合（超标率为0）

    private List<Long> checkIds;

    private Integer yearFlag;

    //是否需要显示检测存在的危害因素字符串
    private Boolean ifNeedHarms=false;
}
