package cn.smarthse.services.hfi.api.model;

import lombok.Data;

import java.io.Serializable;

/**
 * @author 邓力宾
 * @date 2021/1/7 9:33
 * @desc 检测次数统计查询条件
 */
@Data
public class CountParamModel implements Serializable {

    public CountParamModel() {
    }

    public CountParamModel(Integer year, Long cid,
                           Integer checkType,
                           Integer editStatus,
                           Integer reportStatus) {
        this.year = year;
        this.cid = cid;
        this.checkType = checkType;
        this.editStatus = editStatus;
        this.reportStatus = reportStatus;
    }

    private  Integer year; //年份

    private Long cid; // 企业id

    //检测类型
    //1:日常监测
    //2:定期检测
    //3:现状评价涉及的检测
    //4:控评涉及的检测
    //5:整改后检测
    private Integer checkType;

    private Integer editStatus; //编辑状态(1:编辑中/存草稿 2：已完成编辑

    private Integer reportStatus; //上报状态(1:未上报 2：已上报 3：被退回 4:已忽略)

}
