package cn.smarthse.services.hfi.api.model;

import lombok.Data;

import java.io.Serializable;

/**
 * @author 邓力宾
 * @date 2020/11/10 14:55
 * @desc 企业经济类型（注册类型模型）
 */
@Data
public class ComRegisterTypeModel implements Serializable {

    private Long cid; //企业id
    private Long registerType; //注册类型

    /** 注册类型
     *      3, '国有企业'
     *      4, '集体企业'
     *      5, '股份合作企业'
     *      6, '联营企业'
     *      11, '有限责任公司'
     *      14, '股份有限公司'
     *      15, '私营企业'
     *      22, '其他企业'
     *      23, '港、澳、台商投资企业'
     *      29, '外商投资企业'
     *      4258, '个人独资企业'
     *      4259, '非企业单位'
     *      4260, '事业单位'
     *      4261, '其他'
     */
    private Long industryCategory;//行业

    private Long companyType;//规模

    private Long occupationalRiskClassify;//风险分类

}
