package cn.smarthse.services.hfi.api.model;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author 邓力宾
 * @date 2020/10/14 14:07
 * @desc 企业端 检测列表查询 条件 实施版
 */
@Data
public class ComCheckQueryModel implements Serializable {


    private Long staffId;//当前用户id
    private Long deptId; //当前用户部门id

    private List<Long> deptIds; //当前用户能看到的部门id，传null 查全部

    private List<Long> checkTypes; //检测类型

    private String queryDeptIds;// 当前用户能看到的部门id 查询sql用，不作为参数传递

    private Long cid; //企业id

    private String keyword;// 关键字 工作编号，工作名称，负责人

    private LocalDateTime checkStartDate;

    private LocalDateTime checkEndDate;

    //上报日期
    private LocalDateTime reportStartDate;

    private LocalDateTime reportEndDate;

    private Integer checkServiceType;//检测服务类型 0 委外检测； 1 自行检测

    private Integer editStatus;//编辑状态 1:编辑中 2：完成

    private Integer reportStatus;//上报状态 1：待上报 2：已上报

    private Integer relevanceStatus;// 数据关联工作状态 0:无关联 1：进行中 2：已完成


}
