package cn.smarthse.services.hfi.api.model;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * @author 邓力宾
 * @date 2020/10/29 09:22
 * @desc 检测结果查询对象
 */
@Data
public class CheckResultParseQueryModel implements Serializable {
    private Long cid; //企业id
    private List<Long> checkTypes; //检测类型 1, '日常监测' 2, '定期检测' 3, '现状评价涉及的检测' 4, '控评涉及的检测'
    private LocalDateTime checkBeginStart; //检测开始时间下限
    private LocalDateTime checkBeginEnd; //检测开始时间上限
    private Long checkId; //检测id
    private Integer reportStatus;//上报状态 1:未上报 2：已上报 3：被退回

    private Set<Long> factorIds;//只要这些指定的危害因素 传null表示无该条件限制
}
