package cn.smarthse.services.hfi.api.model;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author 邓力宾
 * @date 2021/1/8 10:09
 * @desc
 */
@Data
public class BaseStatQueryModel implements Serializable {

    private Integer page;
    private Integer rows;
    private String sidx; // 排序字段名称
    private String sord; // 排序方式 如:desc, asc
    private Long areaId;//统计的区域id
    private Byte areaLevel; //统计的区域级别
    private Integer groupType;//分组类型 1.行政区划 2.经济类型 3.行业类别 4.企业规模 5.风险分类

    //时间范围
    private LocalDateTime startBegin; //检测时间 开始
    private LocalDateTime startEnd; //检测时间结束

    private Boolean filterEmpty=true;//是否过滤空的 默认true
    public String getCacheKey(){
        return areaId +"_"+groupType+"_"+filterEmpty;
    }

    public String getGroupTypeName(){
        if(groupType == null){
            groupType = 1;
        }
        switch (groupType) {
            case 1:
                return "行政区划";
            case 2:
                return "经济类型";
            case 3:
                return "行业类别";
            case 4:
                return "企业规模";
            case 5:
                return "风险分类";
            default:
                return "";
        }
    }
}
