package cn.smarthse.services.hfi.api.enums;

/**
 * @author 邓力宾
 * @date 2020/10/21 09:21
 * @desc  职业接触限值枚举
 *      '噪声'
 *      '高温'
 *      '紫外辐射'
 *      '工频电场'
 *      '微波辐射'
 *      '高频电磁场'
 *      '超高频辐射'
 *      '电离辐射'
 *      '手传振动'
 *      '激光辐射'
 *      '照度'
 *      '微小气候'
 *      '新风量'
 *      '控制风速'
 *
 */
public enum  TouchLimitValueEnum {



    // 噪声
    Noise26("噪声", 26, "-", "检测数值[dB(A)]"),
    Noise29("噪声", 29, "85", "8/40h等效声级[dB(A)]"),
    Noise31("噪声", 31, "-", "声压级峰值[dB(A)]"),

    // 高温
    HighTemperature36("高温",36,"25~33","检测结果(℃)"),

    //紫外辐射
    UltravioletRadiation41("紫外辐射",41,"0.13~0.26","辐照度(μW/cm²)"),
    UltravioletRadiation42("紫外辐射",42,"1.8~3.7","照射量(mJ/cm²)"),

    //工频电场
    PowerFrequency55("工频电场",55,"5","电场强度（kV/m"),

    //微波辐射
    MicrowaveRadiation60("微波辐射",60,"-","日剂量(μW·h/cm²)"),
    MicrowaveRadiation61("微波辐射",61,"-","平均功率密度(μW/cm²)"),
    MicrowaveRadiation62("微波辐射",62,"5","短时间接触功率密度(mW/cm²)"),

    //高频电磁场
    HighFrequencyElectromagnetic67("高频电磁场",67,"25~50","电场强度(V/m)"),
    HighFrequencyElectromagnetic68("高频电磁场",68,"5","磁场强度(A/m)"),

    // 超高频辐射
    UhfRadiation73("超高频辐射",73,"0.025~0.1","功率密度(mW/cm²)"),
    UhfRadiation74("超高频辐射",74,"10~19","电场强度(V/m)"),

    // 电离辐射
    IonizingRadiation78("电离辐射",78,"2.5×10⁻³ ~ <5","检测结果（μSv/h）"),
    IonizingRadiation80("电离辐射",80,"2.5×10⁻³ ~ <5","检测结果（μSv/h）"),

    // 手传振动
    HandVibration86("手传振动",86,"5","4h等能量频率计权振动加速度(m/s²)"),

    // 激光辐射
    LaserRadiation94("激光辐射",94,"-","照射量(J/cm²)"),
    LaserRadiation95("激光辐射",95,"-","辐照度(W/cm²)"),

    // 照度
    Illumination106("照度",106,null,"检测结果(Lx)"),

    // 微小气候
    TinyWeather109("微小气候",109,null,"温度(℃)"),
    TinyWeather111("微小气候",111,null,"风速(m/s)"),
    TinyWeather113("微小气候",113,null,"相对湿度(%)"),

    // 新风量
    FreshAir116("新风量",116,null,"检测结果(m³/h)"),

    // 控制风速
    AirSpeed("控制风速",122,null,"检测结果(m/s)");


    public String factorName; //危害因素名称

    public Integer targetId; // 指标id

    public String limitValue;//限值

    public String limitUnit; //限值单位

    TouchLimitValueEnum(String factorName, Integer targetId,
                                String limitValue, String limitUnit){
        this.factorName = factorName;
        this.targetId = targetId;
        this.limitValue = limitValue;
        this.limitUnit = limitUnit;
    }

}
