package cn.smarthse.services.hfi.api.enums;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum JudgeStateEnum {
//3:不判定 1:符合 2:不符合
	none("不判定","1"),
	pass("符合","2"),
	fail("不符合","3");

	// 成员变量
	private String name;
	private String code;
	// 构造方法

	private JudgeStateEnum(String name, String code) {
		this.name = name;
		this.code = code;
	}
	// 普通方法
	public static String getName(String code) {
		if (code == null) {
			return null;
		}
		for (JudgeStateEnum c : JudgeStateEnum.values()) {
			if (c.getCode().equals(code)) {
				return c.name;
			}
		}
		return null;
	}


	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
}
