package cn.smarthse.services.hfi.api.enums;

import cn.smarthse.services.hfi.api.pojo.vo.riskev.HazardsExposureRiskLevelVo;

import java.util.Arrays;
import java.util.List;

/**
 * @author 邓力宾
 * @date 2022/3/23 11:08
 * @desc
 */
public enum HazardsExposureRiskLevelEnum {
    //1：低风险（Ⅰ级），2：中风险（Ⅱ级），3：高风险（Ⅲ级）
    lowRisk(1, "Ⅰ级"),
    middleRisk(2, "Ⅱ级"),
    heightRisk(3, "Ⅲ级"),
    none(4, "-");

    HazardsExposureRiskLevelEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    private Integer code;

    private String name;

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    /**
     * 2022.11改版之之前
     */
    public static HazardsExposureRiskLevelEnum getThisEnumByStandardEnumAndStaffCountOld(HarmNatureStandardEnum standard, int staffCount) {
        if (standard != null) {
            if (HarmNatureStandardEnum.generalNotOver.equals(standard)) {
                if (staffCount == 0) {
                    return none;
                } else {
                    return lowRisk;
                }

            } else if (HarmNatureStandardEnum.generalOver.equals(standard)) {
                if (staffCount == 0) {
                    return none;
                }
                if (staffCount <= 9) {
                    return lowRisk;
                } else if (staffCount <= 49) {
                    return middleRisk;
                } else {
                    return heightRisk;
                }
            } else if (HarmNatureStandardEnum.seriousNotOver.equals(standard)) {
                if (staffCount == 0) {
                    return none;
                }
                if (staffCount <= 49) {
                    return middleRisk;
                } else {
                    return heightRisk;
                }
            } else if (HarmNatureStandardEnum.seriousOver.equals(standard)) {
                if (staffCount == 0) {
                    return none;
                }
                if (staffCount <= 9) {
                    return middleRisk;
                } else {
                    return heightRisk;
                }
            }
        }
        return null;
    }


    /**
     * 2022.11改版之后
     */
    public static HazardsExposureRiskLevelEnum getThisEnumByStandardEnumAndStaffCountNew(HarmNatureStandardEnum standard, int staffCount) {
        if (standard != null) {
            // 一般职业病危害因素-符合
            if (HarmNatureStandardEnum.generalNotOver.equals(standard)) {
                if (staffCount == 0) {
                    return none;
                } else {
                    return lowRisk;
                }
            }
            // 一般职业病危害因素-不符合
            else if (HarmNatureStandardEnum.generalOver.equals(standard)) {
                if (staffCount == 0) {
                    return none;
                }
                if (staffCount <= 49) {
                    return middleRisk;
                } else {
                    return heightRisk;
                }
            }
            // 严重职业病危害因素-符合
            else if (HarmNatureStandardEnum.seriousNotOver.equals(standard)) {
                if (staffCount == 0) {
                    return none;
                }
                if (staffCount <= 49) {
                    return middleRisk;
                } else {
                    return heightRisk;
                }
            }
            // 严重职业病危害因素-不符合
            else if (HarmNatureStandardEnum.seriousOver.equals(standard)) {
                if (staffCount == 0) {
                    return none;
                } else {
                    return heightRisk;
                }
            }
        }
        return null;
    }

    public static HazardsExposureRiskLevelVo getFinalThisEnumByStaffCountOld(int generalOverStaffCount, int generalNotOverStaffCount,
                                                                             int seriousOverStaffCount, int seriousNotOverStaffCount) {

        HazardsExposureRiskLevelVo vo = new HazardsExposureRiskLevelVo();

        //一般职业病危害因素-符合 风险等级
        HazardsExposureRiskLevelEnum levelEnum1 = HazardsExposureRiskLevelEnum.getThisEnumByStandardEnumAndStaffCountOld(
                HarmNatureStandardEnum.generalNotOver, generalNotOverStaffCount);

        //一般职业病危害因素-不符合 风险等级
        HazardsExposureRiskLevelEnum levelEnum2 = HazardsExposureRiskLevelEnum.getThisEnumByStandardEnumAndStaffCountOld(
                HarmNatureStandardEnum.generalOver, generalOverStaffCount);

        //严重职业病危害因素-符合 风险等级
        HazardsExposureRiskLevelEnum levelEnum3 = HazardsExposureRiskLevelEnum.getThisEnumByStandardEnumAndStaffCountOld(
                HarmNatureStandardEnum.seriousNotOver, seriousNotOverStaffCount);

        //严重职业病危害因素-不符合 风险等级
        HazardsExposureRiskLevelEnum levelEnum4 = HazardsExposureRiskLevelEnum.getThisEnumByStandardEnumAndStaffCountOld(
                HarmNatureStandardEnum.seriousOver, seriousOverStaffCount);

        vo.setGeneralNotOverRiskLevel(levelEnum1.name);
        vo.setGeneralOverRiskLevel(levelEnum2.name);
        vo.setSeriousNotOverRiskLevel(levelEnum3.name);
        vo.setSeriousOverRiskLevel(levelEnum4.name);

        //风险风险等级
        List<HazardsExposureRiskLevelEnum> list = Arrays.asList(levelEnum1, levelEnum2, levelEnum3, levelEnum4);
        list.sort((o1, o2) -> o2.getCode().compareTo(o1.getCode()));
        for (HazardsExposureRiskLevelEnum levelEnum : list) {
            if (!HazardsExposureRiskLevelEnum.none.equals(levelEnum)) {
                vo.setRiskLevel(levelEnum.name);
                return vo;
            } else {
                vo.setRiskLevel(HazardsExposureRiskLevelEnum.none.name);
            }
        }
        return vo;
    }

    public static HazardsExposureRiskLevelVo getFinalThisEnumByStaffCountNew(int generalOverStaffCount, int generalNotOverStaffCount,
                                                                             int seriousOverStaffCount, int seriousNotOverStaffCount) {

        HazardsExposureRiskLevelVo vo = new HazardsExposureRiskLevelVo();

        //一般职业病危害因素-符合 风险等级
        HazardsExposureRiskLevelEnum levelEnum1 = HazardsExposureRiskLevelEnum.getThisEnumByStandardEnumAndStaffCountNew(
                HarmNatureStandardEnum.generalNotOver, generalNotOverStaffCount);

        //一般职业病危害因素-不符合 风险等级
        HazardsExposureRiskLevelEnum levelEnum2 = HazardsExposureRiskLevelEnum.getThisEnumByStandardEnumAndStaffCountNew(
                HarmNatureStandardEnum.generalOver, generalOverStaffCount);

        //严重职业病危害因素-符合 风险等级
        HazardsExposureRiskLevelEnum levelEnum3 = HazardsExposureRiskLevelEnum.getThisEnumByStandardEnumAndStaffCountNew(
                HarmNatureStandardEnum.seriousNotOver, seriousNotOverStaffCount);

        //严重职业病危害因素-不符合 风险等级
        HazardsExposureRiskLevelEnum levelEnum4 = HazardsExposureRiskLevelEnum.getThisEnumByStandardEnumAndStaffCountNew(
                HarmNatureStandardEnum.seriousOver, seriousOverStaffCount);

        vo.setGeneralNotOverRiskLevel(levelEnum1.name);
        vo.setGeneralOverRiskLevel(levelEnum2.name);
        vo.setSeriousNotOverRiskLevel(levelEnum3.name);
        vo.setSeriousOverRiskLevel(levelEnum4.name);

        //风险风险等级
        List<HazardsExposureRiskLevelEnum> list = Arrays.asList(levelEnum1, levelEnum2, levelEnum3, levelEnum4);
        list.sort((o1, o2) -> o2.getCode().compareTo(o1.getCode()));
        for (HazardsExposureRiskLevelEnum levelEnum : list) {
            if (!HazardsExposureRiskLevelEnum.none.equals(levelEnum)) {
                vo.setRiskLevel(levelEnum.name);
                return vo;
            } else {
                vo.setRiskLevel(HazardsExposureRiskLevelEnum.none.name);
            }
        }
        return vo;
    }

    /*
     * @Comments:  <职业病危害暴露风险等级判断规则一般职业病危害因素和严重职业病危害因素同时存在时，依风险分类高者判别>
     * generalOverStaffCount  一般职业病危害因素超标人数  generalTotalStaffCount 一般职业病危害因素总人数
     *  seriousOverStaffCount  严重职业病危害因素超标人数 seriousOverTotalStaffCount 严重职业病危害因素总人数
     **/
//        public  static HazardsExposureRiskLevelEnum  getFinalThisEnumByStaffCount(int generalOverStaffCount,int generalTotalStaffCount,
//                                                                                  int seriousOverStaffCount,int seriousOverTotalStaffCount){
//            HarmNatureStandardEnum general=HarmNatureStandardEnum.getThisGeneralEnumByStaffCount(generalOverStaffCount);
//            HarmNatureStandardEnum serious=HarmNatureStandardEnum.getThisSeriousEnumByStaffCount(seriousOverStaffCount);
//            HazardsExposureRiskLevelEnum generalLevel=getThisEnumByStandardEnumAndStaffCount(general,generalTotalStaffCount);
//            HazardsExposureRiskLevelEnum seriousLevel=getThisEnumByStandardEnumAndStaffCount(serious,seriousOverTotalStaffCount);
//            if(generalLevel==null&&seriousLevel==null){
//                return null;
//            }else {
//                if(generalLevel==null&&seriousLevel!=null) {
//                    return seriousLevel;
//                }else if(generalLevel!=null&&seriousLevel==null){
//                    return generalLevel;
//                }else {
//                    Integer code= generalLevel.getCode();
//                    return  code>seriousLevel.getCode()?generalLevel:seriousLevel;
//                }
//            }
//
//        }

}