package cn.smarthse.services.hfi.api.enums;

/**
 * @author 邓力宾
 * @date 2022/3/23 11:07
 * @desc
 */
public  enum  HarmNatureStandardEnum {

        generalNotOver(1,1,"一般职业病危害因素-符合"),
        generalOver(2,1,"一般职业病危害因素-不符合"),
        seriousNotOver(3,2,"严重职业病危害因素-符合"),
        seriousOver(4,2,"严重职业病危害因素-不符合");

        HarmNatureStandardEnum(Integer code,Integer type,String name){
            this.code=code;
            this.type=type;
            this.name=name;
        }

        private Integer code;
        /*
         * 1:一般职业病危害因素
         * 2:严重职业病危害因素
         **/
        private Integer type;


        private String name;

        public Integer getCode() {
            return code;
        }

        public Integer getType() {
            return type;
        }

        /*
         * @Comments:  <一般职业病危害因素和严重职业病危害因素的接触人数（超标人数+不超标人数）、是否超标（超标人数大于0为超标）判断>
         * overStaffCount :超标人数
         * @since 上午9:38 2021/12/8
         **/
        public static HarmNatureStandardEnum getThisEnumByTypeAndStaffCount(int type,int overStaffCount){
            if(type==1){
                if(overStaffCount>0){
                    return  generalOver;
                }else {
                    return  generalNotOver;
                }
            } else if(type==2){
                if(overStaffCount>0){
                    return seriousOver;
                }else {
                    return seriousNotOver;
                }
            }else {
                return null;
            }
        }
        public static HarmNatureStandardEnum getThisGeneralEnumByStaffCount(int overStaffCount){

            return getThisEnumByTypeAndStaffCount(1,overStaffCount);
        }

        public static HarmNatureStandardEnum getThisSeriousEnumByStaffCount(int overStaffCount){

            return getThisEnumByTypeAndStaffCount(2,overStaffCount);
        }
}
