package cn.smarthse.services.hfi.api.entity.riskev;

import cn.smarthse.db.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.text.DecimalFormat;

/**
 * <p>
 * 暴露风险评估表-数据表
 * </p>
 *
 * @author 邓力宾
 * @since 2022-03-16
 */
@Data

@ApiModel(value="RiskExposeEvaluateData对象", description="暴露风险评估表-数据表")
public class RiskExposeEvaluateData extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "暴露风险评估表id")
    private Long riskExposeEvaluateId;

    @ApiModelProperty(value = "车间名称")
    private String workshop;

    @ApiModelProperty(value = "岗位/工种")
    private String workName;

    @ApiModelProperty(value = "定员")
    private Integer workNum;

    @ApiModelProperty(value = "检测点/检测对象名称")
    private String checkPoint;

    @ApiModelProperty(value = "危害因素id")
    private String factorId;

    @ApiModelProperty(value = "危害因素名称")
    private String factorName;


    @ApiModelProperty(value = "ctwa值")
    private String ctwa;

    @ApiModelProperty(value = "cstel值")
    private String cstel;

    @ApiModelProperty(value = "cste值")
    private String cste;

    @ApiModelProperty(value = "cmac值")
    private String cmac;

    @ApiModelProperty(value = "cme值")
    private String cme;

    @ApiModelProperty(value = "超限倍数")
    private String exceedLimit;

    @ApiModelProperty(value = "PE/PC-TWA")
    private String pePcTwa;

    @ApiModelProperty(value = "折减因子")
    private String reductionFactor;

    @ApiModelProperty(value = "噪声等效声级")
    private String noiseLevel;

    @ApiModelProperty(value = "其他因素浓度/强度,格式: 参数名称：检测结果/参数名称：检测结果...")
    private String otherFactorValue;

    @ApiModelProperty(value = "接触水平(根据检测值计算来) 1:超标 2：不超标")
    private Integer touchLevel;

    @ApiModelProperty(value = "接触水平(来自检测,手动填的)(是否超标看这个) 1:超标 2：不超标")
    private Integer checkTouchLevel;



    @ApiModelProperty(value = "职业病危害因素性质 1:一般 2：严重")
    private Integer factorNature;

    @ApiModelProperty(value = "能否编辑")
    private Boolean canEdit;

    @ApiModelProperty(value = "该危害因素的时间加权平均容许浓度（PC-TWA）")
    private  String factorAttrTwa;

    @ApiModelProperty(value = "危害因素是否异常")
    private  Boolean factorAbnormal;

    @ApiModelProperty(value = "危害因素来源(1-手动生成，2-汝城4.1~8.1号的检测)")
    private  Integer dataSource;



    @TableField(exist = false)
    private String PCTWA; //pepctwa / factorAttrTwa
    @TableField(exist = false)
    private String createDateStr;

    @TableField(exist = false)
    private String updateDateStr;

    @TableField(exist = false)
    private Boolean isFangShe = false;

    public String getPCTWA() {
        String pePcTwa = this.pePcTwa;
        String attrTwa =this.factorAttrTwa;
        if(attrTwa == null || attrTwa.isEmpty()){
            return  pePcTwa;
        }
        try{
            double v = Double.parseDouble(pePcTwa) / Double.parseDouble(attrTwa);
            if(v >0){
                return String.format("%.2f", v);
            }
            return getCeilDouble(v)+"";
        }catch (NumberFormatException e){
            return pePcTwa;
        }
    }

    //小数部分取到第一个非0位，并向正上取值
    public double getCeilDouble(double number) {
        String str = new DecimalFormat("0.0000000000").format(number);        //将number格式化为小数点后面有10位数的小数
        String[] fore = str.split("[1-9]", 2);//截取小数前面为0的部分《如：0.0002，取0.000）
        String[] split = str.split(".", 2);        //截取小数点后面的部分(包含了小数点)
        int aft = Integer.parseInt(split[1].substring(1));    //去除小数点然后转成整数
        int len = (aft+"").length();//获取有几位数
        aft=(int) Math.ceil(aft/Math.pow(10, len-1));        //最后保留1位（向正取值）
        return Double.parseDouble(fore[0]+aft);
    }


}
