package cn.smarthse.services.hfi.api.entity.riskev;


import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.db.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 暴露风险评估表
 * </p>
 *
 * @author 邓力宾
 * @since 2022-03-16
 */
@Data
@ApiModel(value="RiskExposeEvaluate对象", description="暴露风险评估表")
public class RiskExposeEvaluate extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "类型(1:来自检测 2：来自手动添加)")
    private Integer type;

    @ApiModelProperty(value = "如果来自检测，检测id")
    private Long checkPlanId;

    @ApiModelProperty(value = "企业id")
    private Long cid;

    @ApiModelProperty(value = "机构id")
    private Long orgId;

    @TableField(exist = false)
    private String orgName;

    @ApiModelProperty(value = "工作编号")
    private String workNo;

    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "检测时间")
    private LocalDateTime checkDate;
    @ApiModelProperty(value = "检测时间(结束)")
    private LocalDateTime checkDateEnd;


    @ApiModelProperty(value = "使用的标准1:2007, 2:2019")
    private Long targetStandardId;

    @ApiModelProperty(value = "项目区域id")
    private Long projectAreaId;

    @ApiModelProperty(value = "项目详细地址")
    private String projectAddress;

    @ApiModelProperty(value = "风险类别，1：严重，2：一般")
    private Integer riskType;

    @ApiModelProperty(value = "提交状态(1:待提交 2：待审核 3：被退回待提交 4：审核完成 5:最新的审核通过之后的中间数据 10：错误数据")
    private Integer reportStatus;

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime reportDate;

    @ApiModelProperty(value = "数据更新时间")
    private LocalDateTime dataUpdateDate;

    @ApiModelProperty(value = "1：低风险（Ⅰ级），2：中风险（Ⅱ级），3：高风险（Ⅱ级） ")
    private Integer riskLevel;

    @ApiModelProperty(value = "是否忽略")
    private Boolean isIgnore;

    @ApiModelProperty(value = "检测类型: 1日常监测 2定期检测、3现状评价、4控制效果评价")
    private Long checkType;

    @ApiModelProperty(value = "来源或去向id（退回时用的）")
    private Long sourceId;

    @ApiModelProperty(value = "标记类型，0原表，1副本表，2退回上报之后的历史数据表（退回时用的）")
    private Integer flag;

    @ApiModelProperty(value = "冗余表的id，指那张表揉进来的")
    private String redundantSourceTablesIds;

    @ApiModelProperty(value = "万达检测表id")
    private String wandaZywsCheckId;

    @ApiModelProperty(value = "万达检测表id")
    private String wandaZywsReportId;

    @TableField(exist = false)
    private String checkDateStr;
    @TableField(exist = false)
    private String checkDateEndStr;
    @TableField(exist = false)
    private String reportDateStr;
    @TableField(exist = false)
    private String dataUpdateDateStr;
    @TableField(exist = false)
    private String createDateStr;
    @TableField(exist = false)
    private String updateDateStr;
    //接害人数,最新更新时间，岗位部门
    @TableField(exist = false)
    private Integer workNum;
    @TableField(exist = false)
    private LocalDateTime lastDate;
    @TableField(exist = false)
    private String workShopName;
    @TableField(exist = false)
    private List<RiskExposeEvaluateData> dataList;

    public String getCheckDateStr() {
        if (checkDate==null) return "";
        return DateUtil.formatDate(checkDate);
    }
}
