package cn.smarthse.services.hfi.api.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 电离辐射-含源装置表
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="RaySourceDevice对象", description="电离辐射-含源装置表")
public class RaySourceDevice extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "检测id")
    private Long checkId;

    @ApiModelProperty(value = "装置名称")
    private String name;

    @ApiModelProperty(value = "放射源编号")
    private String raySourceNo;

    @ApiModelProperty(value = "标号")
    private String signNo;

    @ApiModelProperty(value = "核素,格式:元素名称-原子量")
    private String nucleusEl;

    @ApiModelProperty(value = "当前活度（Bq）")
    private String nowActiveDegree;

    @ApiModelProperty(value = "出厂活度（Bq）")
    private String factoryActiveDegree;

    @ApiModelProperty(value = "安装位置")
    private String installLocation;

    @ApiModelProperty(value = "检测点所在车间(v315车间名称)")
    private String  workshopName;

    @ApiModelProperty(value = "岗位/工种(v315岗位名称)")
    private String  workName;

    @ApiModelProperty(value = "接触人数（v315定员）")
    private Integer harmStaffCount;

}
