package cn.smarthse.services.hfi.api.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 电离辐射-射线装置表
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="RayDevice对象", description="电离辐射-射线装置表")
public class RayDevice extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "检测id")
    private Long checkId;

    @ApiModelProperty(value = "装置名称")
    private String name;

    @ApiModelProperty(value = "型号")
    private String modelNo;

    @ApiModelProperty(value = "额定容量")
    private String capacity;

    @ApiModelProperty(value = "检测条件")
    private String checkCondition;

    @ApiModelProperty(value = "场所名称")
    private String siteName;

    @ApiModelProperty(value = "检测点所在车间(v315车间名称)")
    private String  workshopName;

    @ApiModelProperty(value = "岗位/工种(v315岗位名称)")
    private String  workName;

    @ApiModelProperty(value = "接触人数（v315定员）")
    private Integer harmStaffCount;

}
