package cn.smarthse.services.hfi.api.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 检测类型表
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="HcCheckType对象", description="检测类型表")
public class HcCheckType extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "类型名称")
    private String checkTypName;

    @ApiModelProperty(value = "说明")
    private String description;

    @ApiModelProperty(value = "类型标识（1:日常,2:定期,3:现状,4:控评,5:自定义）")
    private String checkTypeFlag;




}
