package cn.smarthse.services.hfi.api.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 企业超标率统计结果表（监管需求02-046）
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-24
 */
@Data
@ApiModel(value="ComOverRate对象", description="企业超标率统计结果表（监管需求02-046）")
public class ComOverRate extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业id")
    private Long cid;

    @ApiModelProperty(value = "企业所属行业id")
    private Long industryId;


    @ApiModelProperty(value = "企业名称")
    private String cName;

    @ApiModelProperty(value = "化学毒物超标率")
    private String chemicalRate;

    @ApiModelProperty(value = "粉尘超标率")
    private String dustRate;

    @ApiModelProperty(value = "噪声检测值（多个用英文逗号隔开）")
    private String noiseValues;

    @ApiModelProperty(value = "总超标率")
    private String totalRate;

    @ApiModelProperty(value = "工作地址")
    private String workAddress;



}
