package cn.smarthse.services.hfi.api.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 指标标准表
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="CheckTargetStandard对象", description="指标标准表")
public class CheckTargetStandard extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "标准名称")
    private String name;

    @ApiModelProperty(value = "有效期开始（为null表示无时间限制）")
    private LocalDateTime startDate;

    @ApiModelProperty(value = "有效期结束（为null表示无时间限制）")
    private LocalDateTime endDate;

    @ApiModelProperty(value = "说明")
    private String description;




}
