package cn.smarthse.services.hfi.api.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 检测指标表
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="CheckTarget对象", description="检测指标表")
public class CheckTarget extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "指标名称")
    private String name;

    @ApiModelProperty(value = "指标单位")
    private String unit;

    @ApiModelProperty(value = "所属检测项id")
    private Integer itemId;

    @ApiModelProperty(value = "值类型1：准确值 2：范围")
    private Integer checkValueType;

    @ApiModelProperty(value = "标签")
    private Integer tag;

    @ApiModelProperty(value = "描述")
    private String description;

    @ApiModelProperty(value = "指标标准id,为0表示公共的")
    private Integer standardId;




}
