package cn.smarthse.services.hfi.api.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 检测选择的检测项目表
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="CheckSelectItem对象", description="检测选择的检测项目表")
public class CheckSelectItem extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "检测id")
    private Long checkId;

    @ApiModelProperty(value = "检测项id")
    private Integer itemId;

    @ApiModelProperty(value = "企业id")
    private Long cid;

    @ApiModelProperty(value = "检测项名称")
    @TableField(exist = false)
    private String itemName;

}
