package cn.smarthse.services.hfi.api.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 检测结果表
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="CheckResult对象", description="检测结果表")
public class CheckResult extends BaseEntity {

    private static final long serialVersionUID = 1L;



    @ApiModelProperty(value = "检测id")
    private Long checkId;

    @ApiModelProperty(value = "企业id")
    private Long cid;

    @ApiModelProperty(value = "结果集编号,相同编号则为同一批录入结果")
    private Long resultNo;

    @ApiModelProperty(value = "指标id")
    private Integer targetId;

    @ApiModelProperty(value = "指标的值（准确值）(结果是准确的值时，该字段有效，结果的类型查看当前指标对应的值类型)")
    private String checkValue;

    @ApiModelProperty(value = "结果是范围时，范围类型：1:-，2:< ，3:<=")
    private Integer checkValueRangeType;

    @ApiModelProperty(value = "指标的值（范围下限）")
    private String checkValueMin;

    @ApiModelProperty(value = "指标的值（范围上限）")
    private String checkValueMax;

    @ApiModelProperty(value = "单位（单位如果是用户填的或需要动态改变的，存该字段）")
    private String unit;

    //危害因素名称，化学、生物、粉尘才有(targetId=2/12/98)
    @TableField(exist = false)
    private String harmName;

    //照射时间、照射量、辐照度(targetId=93/94/95)：值为4个数字，逗号隔开 如:2,3,4,5 表示 2*10³ ~ 4*10⁵
    @TableField(exist = false)
    private String[] radiationArr;
}
