package cn.smarthse.services.hfi.api.entity;

import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.db.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * <p>
 * 检测表
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="CheckPlan对象", description="检测表")
public class CheckPlan extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "企业id")
    private Long cid;
    @ApiModelProperty(value = "检测项检测指标使用的标准id（check_target_standard表）")
    private Long targetStandardId;

    @ApiModelProperty(value = "工作编号")
    private String checkWorkNo;

    @ApiModelProperty(value = "检测工作名称")
    private String checkWorkName;

    @ApiModelProperty(value = "检测开始日期")
    @TableField(updateStrategy = FieldStrategy.IGNORED) // null值也更新
    private LocalDateTime checkDateBegin;

    @ApiModelProperty(value = "检测结束日期")
    @TableField(updateStrategy = FieldStrategy.IGNORED) // null值也更新
    private LocalDateTime checkDateEnd;

    public String getCheckDate(){
        if (checkDateBegin!=null) return DateUtil.formatDate(checkDateBegin);
        return "";
    }



    @ApiModelProperty(value = "检测类型id(hc_check_type表)")
    private Long checkType;

    @ApiModelProperty(value = "来自哪里(1:企业端 2：机构端  3：万达仓)")
    private Integer checkFrom;

    @ApiModelProperty(value = "测负责人（来自企业端）")
    private Long manager;

    @ApiModelProperty(value = "测负责人名称")
    private String managerName;

    @ApiModelProperty(value = "检测服务类型， 0 委外检测； 1 自行检测")
    private Integer checkServiceType;

    @ApiModelProperty(value = "委外检测的第三方机构id")
    private Long thirdOrgId;
    @TableField(exist = false)
    private String thirdOrgName;

    @ApiModelProperty(value = "自行检测的部门id")
    private Long deptId;

    @ApiModelProperty(value = "检测报告名称")
    private String checkReportName;

    @ApiModelProperty(value = "原件存放位置（检测报告）")
    private String checkReportLocation;

    @ApiModelProperty(value = "检测报告(文件id)")
    private String checkReportFileIds;

    @ApiModelProperty(value = "检测委托书/合同原件存放位置")
    private String contractLocation;

    @ApiModelProperty(value = "检测委托书/同(文件id)")
    private String contractFileIds;

    @ApiModelProperty(value = "检测点分布示意图")
    private String checkPointMapFileIds;

    @ApiModelProperty(value = "检测结果公布凭证")
    private String checkResultCertificateFileIds;

    @ApiModelProperty(value = "相关工作评价表主键Id")
    private Long relatedJobEvaluationId;

    @ApiModelProperty(value = "评价id")
    private Long evaluateId;

    @ApiModelProperty(value = "编辑状态(1:编辑中/存草稿 2：已完成编辑)")
    private Integer editStatus;

    @ApiModelProperty(value = "0-正常,3-复采(整改后检测)")
    private Integer checkPlanType;

    @ApiModelProperty(value = "关联检测Id，多个以逗号隔开 check_plan_type=3（复测）有用")
    private String checkPids;

    @ApiModelProperty(value = "项目名称(来自机构端)")
    private String projectName;

    @ApiModelProperty(value = "项目区域id(来自机构端)")
    private Long projectAreaId;

    @ApiModelProperty(value = "项目详细地址(来自机构端)")
    private String projectAddress;


    @ApiModelProperty(value = "报告出具日期(来自机构端)")
    @TableField(updateStrategy = FieldStrategy.IGNORED) //null值也更新
    private LocalDateTime giveReportDate;



    @ApiModelProperty(value = "上报状态(1:未上报 2：已上报 3：被退回 4:忽略)")
    private Integer reportStatus;


    @ApiModelProperty(value = "上报日期(来自机构端)")
    private LocalDateTime reportDate;

    @ApiModelProperty(value = "联系人(来自机构端)")
    private String contactName;

    @ApiModelProperty(value = "联系电话(来自机构端)")
    private String contactPhone;

    @ApiModelProperty(value = "登记人姓名")
    private String registerName;

    @ApiModelProperty(value = "数据关联工作状态(实施版)0:无关联 1：进行中 2：已完成")
    private Integer relevanceStatus;

    @ApiModelProperty(value = "数据关联工作完成时间")
    private LocalDateTime relevanceDate;

    @ApiModelProperty(value = "检测评价报告")
    private String checkEvaluationReportFileIds;

    @ApiModelProperty(value = "检测评价报告源文件存放位置")
    private String checkEvaluationReportLocation;

    @ApiModelProperty(value = "工作记录所属部门id，多个用逗号分隔(实施版)")
    private String orgIds;

    @ApiModelProperty(value = "上一次检测id(整改后检测该字段有效，实施版)")
    private String lastCheckIds;

    @ApiModelProperty(value = "整改后检测涉及的隐患id（多个逗号隔开），实施版")
    private String reformIds;


    @TableField(exist = false)
    private String creator;

    @TableField(exist = false)
    private Boolean read = false; //是否已读（app端）

    /**
     * 检测报告名称 格式改为附件上传
     */
    @TableField(exist = false)
    private Long[]  checkReportNameFileIdArr;

    /**
     *  评价（检测）委托书/合同格式改为附件上传
     */
    @TableField(exist = false)
    private Long[] evaluateOrCheckFileFileIdArr;


    /**
     * 检测点分布示意图(数组)
     */
    @TableField(exist = false)
    private Long[] checkPointMapFileIdsArr;

    /**
     * 检测结果公布凭证(数组)
     */
    @TableField(exist = false)
    private Long[] checkResultCertificateFileIdsArr;

     /**
     * 检测评价报告(数组)
     */
    @TableField(exist = false)
    private Long[] checkEvaluationReportFileIdsArr;

    @TableField(exist = false)
    private String checkDateStr;//检测日期

    @ApiModelProperty(value = "暴露风险评估表")
    private Long riskExposeEvaluateId;

    @ApiModelProperty(value = "万达检测表")
    private String wandaZywsCheckId;

    @ApiModelProperty(value = "行业名称")
    private String industryName;

    @ApiModelProperty(value = "行业类型")
    private String industryCode;

    @ApiModelProperty(value = "职业病危害风险类别,1：严重，2：一般")
    private Integer riskLevel;

    public String getCheckDateStr(){
        LocalDateTime checkDateBegin = getCheckDateBegin();
        LocalDateTime checkDateEnd = getCheckDateEnd();
        StringBuilder sb = new StringBuilder();
        if(checkDateBegin != null){
            sb.append(DateUtil.formatDate(checkDateBegin, "yyyy-MM-dd"));
            sb.append("至");
        }
        if(checkDateEnd != null){
            sb.append(DateUtil.formatDate(checkDateEnd, "yyyy-MM-dd"));
        }
        return sb.toString();
    }
    @TableField(exist = false)
    private Boolean hasReform;


}
