package cn.smarthse.services.hfi.api.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 检测超标统计（统计表）
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="CheckOverPoint对象", description="检测超标统计（统计表）")
public class CheckOverPoint extends BaseEntity {


    @ApiModelProperty(value = "企业id")
    private Long cid;

    @ApiModelProperty(value = "检测id")
    private Long checkId;

    @ApiModelProperty(value = "检测点")
    private Integer checkPoint;

    @ApiModelProperty(value = "合格点")
    private Integer passPoint;

    @ApiModelProperty(value = "超标点")
    private Integer overPoint;



}
