package cn.smarthse.services.hfi.api.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 检测项表
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="CheckItem对象", description="检测项表")
public class CheckItem extends BaseEntity {

    private static final long serialVersionUID = 1L;



    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "1:危害因素类型 2：危害因素 3：既不是危害因素类型也不是危害因素表中的危害因素")
    private Integer itemType;

    @ApiModelProperty(value = "item_type为1时有效,危害因素类型 occupational_risk_factors表type字段")
    private String factorType;

    @ApiModelProperty(value = "item_type为2时有效,危害因素id occupational_risk_factors表id字段")
    private Long factorId;




}
