package cn.smarthse.services.hfi.api.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * <p>
 * 检测历史数据
 * </p>
 *
 * @author 邓力宾
 * @since 2020-09-10
 */
@Data
@ApiModel(value="CheckHistoryData对象", description="检测历史数据")
public class CheckHistoryData extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "企业id")
    private Long cid;

    @ApiModelProperty(value = "检测id")
    private Long checkId;

    @ApiModelProperty(value = "json格式数据")
    private String data;

    @ApiModelProperty(value = "是否有效（0-无效，1-有效）")
    private Boolean isValid;

    @ApiModelProperty(value = "创建人")
    private Long createBy;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "最后修改人ID")
    private Long updateBy;

    @ApiModelProperty(value = "最后修改时间")
    private LocalDateTime updateDate;


}
