package cn.smarthse.services.hfi.api.entity;


import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author author
 * @since 2022-11-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="CheckFactorTemp对象", description="")
public class CheckFactorTemp extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;


    private Long cid;

    @ApiModelProperty(value = "检测日期")
    private LocalDateTime checkDate;

    @ApiModelProperty(value = "最近一次的任何类型检测id")
    private Long checkId;

    @ApiModelProperty(value = "最近一次的暴露风险id")
    private Long riskId;

    @ApiModelProperty(value = "最近一次的存在的危害因素")
    private String harmsName;

    @ApiModelProperty(value = "最近一次的存在的危害因素id")
    private String harmsId;

    @ApiModelProperty(value = "最近一次的存在的危害因素code")
    private String paramCode;

    @ApiModelProperty(value = "检测结果是否超标，最近，历次，不存在超标等")
    private String result;

    @ApiModelProperty(value = "危害因素的类型")
    private String type;

    @ApiModelProperty(value = "数据更新时间")
    private LocalDateTime dataUpdateDate;
}
