package cn.smarthse.services.hfi.api.entity;

import cn.smarthse.db.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 检测涉及的危害因素表（统计表）
 * </p>
 *
 * @author 邓力宾
 * @since 2020-08-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value="CheckFactor对象", description="检测涉及的危害因素表（统计表）")
public class CheckFactor extends BaseEntity {

    @ApiModelProperty(value = "企业id")
    private Long cid;

    @ApiModelProperty(value = "检测id")
    private Long checkId;

    @ApiModelProperty(value = "涉及到的危害因素id")
    private Long factorId;

    @ApiModelProperty(value = "涉及到的危害因素名称")
    private String factorName;




}
